--- @meta

-- This file is autogenerated. Do not edit this file manually. Your changes will be ignored.
-- More information: https://github.com/MWSE/MWSE/tree/master/docs

--- An object that applies a graphical effect on the screen, such as screen glare or damage coloring. For an example of how to set up a custom fader, see [fadersCreated](https://mwse.github.io/MWSE/events/fadersCreated/) event.
--- @class tes3fader
--- @field active boolean The activation state for the fader. Setting this effectively calls activate/deactivate.
tes3fader = {}

--- Creates a new fader, and adds it to the fader system.
---
--- [Examples available in online documentation](https://mwse.github.io/MWSE/types/tes3fader/#new).
--- @param distance? number *Optional*. If no distance is provided, a distance will be calculated based on current amount of faders, `tes3.worldController.projectionDistance` and crosshair node's `translation.y`.
--- @param unknownBool? boolean *Default*: `true`. No description yet available.
--- @return tes3fader fader No description yet available.
function tes3fader.new(distance, unknownBool) end

--- Activates a deactivated fader.
function tes3fader:activate() end

--- Deactivates an activated fader.
function tes3fader:deactivate() end

--- Transitions the fader to a value of `1` over a given duration.
--- @param params tes3fader.fadeIn.params This table accepts the following values:
--- 
--- `duration?`: number — *Default*: `1`. The time it takes to fade, in seconds.
function tes3fader:fadeIn(params) end

---Table parameter definitions for `tes3fader.fadeIn`.
--- @class tes3fader.fadeIn.params
--- @field duration? number *Default*: `1`. The time it takes to fade, in seconds.

--- Transitions the fader to a value of `0` over a given duration.
--- @param params tes3fader.fadeOut.params This table accepts the following values:
--- 
--- `duration?`: number — *Default*: `1`. The time it takes to fade, in seconds.
function tes3fader:fadeOut(params) end

---Table parameter definitions for `tes3fader.fadeOut`.
--- @class tes3fader.fadeOut.params
--- @field duration? number *Default*: `1`. The time it takes to fade, in seconds.

--- Transitions the fader to a value over a given duration.
--- @param params tes3fader.fadeTo.params This table accepts the following values:
--- 
--- `value?`: number — *Default*: `1`. The value to fade to.
--- 
--- `duration?`: number — *Default*: `1`. The time it takes to fade, in seconds.
function tes3fader:fadeTo(params) end

---Table parameter definitions for `tes3fader.fadeTo`.
--- @class tes3fader.fadeTo.params
--- @field value? number *Default*: `1`. The value to fade to.
--- @field duration? number *Default*: `1`. The time it takes to fade, in seconds.

--- Applies a coloring effect to the fader. A fader without a texture will apply a colouring effect over the screen. The colour set here can completely change the color of the fader's texture.
--- @param params tes3fader.setColor.params This table accepts the following values:
--- 
--- `color`: tes3vector3|number[] — The RGB values to set in [0.0, 1.0] range. If passing an array, pass 3 numbers.
--- 
--- `flag?`: boolean — *Default*: `false`. No description yet available.
--- @return boolean result No description yet available.
function tes3fader:setColor(params) end

---Table parameter definitions for `tes3fader.setColor`.
--- @class tes3fader.setColor.params
--- @field color tes3vector3|number[] The RGB values to set in [0.0, 1.0] range. If passing an array, pass 3 numbers.
--- @field flag? boolean *Default*: `false`. No description yet available.

--- This method allows changing the texture of the fader.
--- @param path string A path for the texture that will be displayed on screen. Starting in `"Data Files\"`.
function tes3fader:setTexture(path) end

--- Updates the fader for the current frame. This method needs to be called each frame for fader to be present.
function tes3fader:update() end

--- Updates the fader's alpha. The fader needs to be active.
--- @param value number The opacity of the fader in range [0.0, 1.0]
function tes3fader:updateMaterialProperty(value) end

